/** SKYSEVEN - SMART IMPORT LOGIC */
const API_URL = 'api.php'; 

// Konfigurasi Durasi
const DURATIONS_IMPORT = { portrait: 15, landscape: 15, aquarium: 10, prep: 5 }; 
const MONTH_MAP = { 'januari':0, 'februari':1, 'maret':2, 'april':3, 'mei':4, 'juni':5, 'juli':6, 'agustus':7, 'september':8, 'oktober':9, 'november':10, 'desember':11 };

let parsedSessions = [];

// Fungsi untuk memisahkan teks invoice
function parseData() {
    const rawText = document.getElementById('raw-input').value;
    if (!rawText.trim()) return Swal.fire('Error', 'Input tidak boleh kosong', 'warning');

    const blocks = rawText.split(/(?=INV\d+)/g); 
    const results = [];

    blocks.forEach(block => {
        if (block.length < 20) return; 

        // Deteksi Studio
        let studioId = 1; 
        if (/Self Photo Studio 2/i.test(block)) studioId = 2; 
        else if (/Photobox/i.test(block)) studioId = 3; 

        // Deteksi Background
        const bgMatch = block.match(/Background\s*:\s*([^\n\r\t]+)/i); 
        let bg = bgMatch ? bgMatch[1].trim() : (studioId == 3 ? "Aquarium" : "Gray"); 
        bg = bg.replace(/BNI|QRIS|BRI|PAID|Free Soft File/gi, '').trim(); 
        
        // Deteksi Nama Customer
        let name = "Unknown"; 
        const viewLocIndex = block.indexOf("View location"); 
        if (viewLocIndex !== -1) { 
            const textAfter = block.substring(viewLocIndex + 13); 
            const lines = textAfter.split(/\r?\n/).map(l => l.trim()).filter(l => l !== ""); 
            if(lines.length > 0) name = lines[0]; 
        }

        // Deteksi Waktu
        const dateMatch = block.match(/(Senin|Selasa|Rabu|Kamis|Jumat|Sabtu|Minggu),\s+(\d+)\s+(\w+)\s+(\d{4})\s+(\d{2}:\d{2})/i);
        if (dateMatch) {
            const day = parseInt(dateMatch[2]); 
            const month = MONTH_MAP[dateMatch[3].toLowerCase()] || 0; 
            const year = parseInt(dateMatch[4]); 
            const [hrs, mins] = dateMatch[5].split(':').map(Number);
            
            // Konversi ke Milidetik (Format BIGINT Database)
            const startTime = new Date(year, month, day, hrs, mins, 0, 0).getTime();
            let dur = (studioId == 3) ? DURATIONS_IMPORT.aquarium : (bg.toLowerCase().includes('landscape') ? DURATIONS_IMPORT.landscape : DURATIONS_IMPORT.portrait);
            
            const totalDur = dur + DURATIONS_IMPORT.prep;
            results.push({ 
                studio_id: studioId, customer_name: name, background: bg, 
                start_time: startTime, end_time: startTime + (totalDur * 60 * 1000), 
                duration: totalDur, display_time: `${day}/${month+1} ${hrs}:${String(mins).padStart(2,'0')}`
            });
        }
    });

    if (results.length === 0) return Swal.fire('Gagal', 'Format invoice tidak dikenali', 'error');
    
    parsedSessions = results;
    renderPreview();
}

function renderPreview() {
    const tbody = document.getElementById('preview-body');
    document.getElementById('review-section').classList.remove('hidden');
    
    tbody.innerHTML = parsedSessions.map((s, i) => `
        <tr class="hover:bg-white/5 border-b border-borderline">
            <td class="p-4 text-center"><input type="checkbox" class="row-checkbox" value="${i}" checked></td>
            <td class="p-4 font-mono text-xs text-slate-400">${s.display_time}</td>
            <td class="p-4 font-bold text-white">${s.customer_name}</td>
            <td class="p-4 text-xs">ST.${s.studio_id} - ${s.background}</td>
            <td class="p-4 text-right font-bold text-primary">${s.duration}m</td>
        </tr>
    `).join('');
}

function selectAll(checked) {
    document.querySelectorAll('.row-checkbox').forEach(cb => cb.checked = checked);
}

// Kirim data yang dicentang ke database
async function submitSelected() {
    const checked = document.querySelectorAll('.row-checkbox:checked');
    if (checked.length === 0) return Swal.fire('Peringatan', 'Pilih minimal satu data', 'warning');

    Swal.fire({ title: 'Menyimpan Data...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });

    for (const cb of checked) {
        const data = parsedSessions[cb.value];
        await fetch(`${API_URL}?action=add_session`, {
            method: 'POST',
            body: JSON.stringify(data)
        });
    }

    Swal.fire({ icon: 'success', title: 'Berhasil', text: 'Semua data telah diimport', confirmButtonColor: '#22c55e' })
        .then(() => window.location.href = 'index.html');
}
