<?php
// FILE: api.php - SKYSEVEN MANAGER (QUEUE EDITION)
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

ini_set('display_errors', 0);
error_reporting(E_ALL);

require 'db.php'; 

$action = isset($_GET['action']) ? $_GET['action'] : '';

// --- HELPER FUNCTION ---
function sendResponse($status, $data = null, $message = null) {
    echo json_encode(['status' => $status, 'data' => $data, 'message' => $message]);
    exit;
}

// 1. LOGIN
if ($action == 'login') {
    $data = json_decode(file_get_contents("php://input"), true);
    try {
        $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
        $stmt->execute([$data['username']]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user && $user['password'] === $data['password']) {
            sendResponse('success', ['user' => $user['username'], 'role' => $user['role']]);
        } else {
            sendResponse('error', null, 'Login gagal');
        }
    } catch (Exception $e) { sendResponse('error', null, $e->getMessage()); }
}

// 2. GET SESSIONS (ADMIN VIEW)
elseif ($action == 'get_sessions') {
    try {
        // Ambil semua data termasuk info antrian
        $stmt = $pdo->query("SELECT * FROM sessions ORDER BY start_time ASC");
        $sessions = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        $cleanData = [];
        foreach($sessions as $s) {
            $s['id'] = (int)$s['id'];
            $s['studio_id'] = (int)$s['studio_id'];
            $s['start_time'] = (float)$s['start_time']; 
            $s['end_time'] = (float)$s['end_time'];
            $s['duration'] = isset($s['duration_minutes']) ? (int)$s['duration_minutes'] : (int)$s['duration'];
            $s['queue_number'] = (int)$s['queue_number'];
            $cleanData[] = $s;
        }
        echo json_encode($cleanData);
    } catch (Exception $e) { sendResponse('error', null, $e->getMessage()); }
}

// 3. GENERATE QR TOKEN (Buat Link Customer)
elseif ($action == 'generate_token') {
    $data = json_decode(file_get_contents("php://input"), true);
    $id = $data['id'];
    
    try {
        // Cek apakah sudah punya UUID
        $check = $pdo->prepare("SELECT uuid FROM sessions WHERE id = ?");
        $check->execute([$id]);
        $row = $check->fetch(PDO::FETCH_ASSOC);
        
        if ($row && $row['uuid']) {
            sendResponse('success', ['uuid' => $row['uuid']]);
        } else {
            // Buat UUID baru
            $uuid = bin2hex(random_bytes(16));
            $update = $pdo->prepare("UPDATE sessions SET uuid = ? WHERE id = ?");
            $update->execute([$uuid, $id]);
            sendResponse('success', ['uuid' => $uuid]);
        }
    } catch (Exception $e) { sendResponse('error', null, $e->getMessage()); }
}

// 4. GET CUSTOMER SESSION (CUSTOMER VIEW)
elseif ($action == 'get_customer_session') {
    $uuid = isset($_GET['uuid']) ? $_GET['uuid'] : '';
    try {
        $stmt = $pdo->prepare("SELECT * FROM sessions WHERE uuid = ?");
        $stmt->execute([$uuid]);
        $s = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($s) {
            // Format data untuk JS
            $s['id'] = (int)$s['id'];
            $s['studio_id'] = (int)$s['studio_id'];
            $s['start_time'] = (float)$s['start_time']; 
            $s['end_time'] = (float)$s['end_time'];
            $s['queue_number'] = (int)$s['queue_number'];
            
            // Cek Info Antrian Global (Siapa yang sedang dilayani)
            $qStmt = $pdo->query("SELECT queue_number, customer_name FROM sessions WHERE queue_status = 'serving' ORDER BY queue_number DESC LIMIT 1");
            $serving = $qStmt->fetch(PDO::FETCH_ASSOC);
            
            sendResponse('success', ['session' => $s, 'current_serving' => $serving]);
        } else {
            sendResponse('error', null, 'Sesi tidak ditemukan');
        }
    } catch (Exception $e) { sendResponse('error', null, $e->getMessage()); }
}

// 5. JOIN QUEUE (CUSTOMER ACTION)
elseif ($action == 'join_queue') {
    $data = json_decode(file_get_contents("php://input"), true);
    $uuid = $data['uuid'];
    
    try {
        // Cek status saat ini
        $stmt = $pdo->prepare("SELECT id, queue_status, queue_number FROM sessions WHERE uuid = ?");
        $stmt->execute([$uuid]);
        $s = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($s['queue_status'] == 'idle') {
            // Generate Nomor Antrian Baru (Max + 1)
            // Reset harian bisa ditambahkan logic WHERE date... disini. Untuk simpel, kita global increment dulu.
            $maxStmt = $pdo->query("SELECT MAX(queue_number) as max_q FROM sessions");
            $maxRow = $maxStmt->fetch(PDO::FETCH_ASSOC);
            $newQueue = ($maxRow['max_q'] ? $maxRow['max_q'] : 0) + 1;
            
            $upd = $pdo->prepare("UPDATE sessions SET queue_status = 'waiting', queue_number = ? WHERE uuid = ?");
            $upd->execute([$newQueue, $uuid]);
            
            sendResponse('success', ['queue_number' => $newQueue, 'status' => 'waiting']);
        } else {
            // Sudah punya antrian
            sendResponse('success', ['queue_number' => $s['queue_number'], 'status' => $s['queue_status']], 'Sudah dalam antrian');
        }
    } catch (Exception $e) { sendResponse('error', null, $e->getMessage()); }
}

// 6. QUEUE MANAGEMENT (ADMIN VIEW & ACTIONS)
elseif ($action == 'get_queue_list') {
    try {
        $stmt = $pdo->query("SELECT * FROM sessions WHERE queue_status IN ('waiting', 'serving') ORDER BY queue_status DESC, queue_number ASC");
        $list = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode($list);
    } catch (Exception $e) { sendResponse('error', null, $e->getMessage()); }
}

elseif ($action == 'update_queue_status') {
    $data = json_decode(file_get_contents("php://input"), true);
    try {
        // Status: 'serving' (Panggil) atau 'done' (Selesai)
        $stmt = $pdo->prepare("UPDATE sessions SET queue_status = ? WHERE id = ?");
        $stmt->execute([$data['status'], $data['id']]);
        sendResponse('success');
    } catch (Exception $e) { sendResponse('error', null, $e->getMessage()); }
}

// --- FITUR LAMA (CRUD) ---

elseif ($action == 'add_session') {
    $data = json_decode(file_get_contents("php://input"), true);
    try {
        $sql = "INSERT INTO sessions (studio_id, customer_name, background, start_time, end_time, duration_minutes, status, queue_status) VALUES (?, ?, ?, ?, ?, ?, 'scheduled', 'idle')";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$data['studio_id'], $data['customer_name'], $data['background'], $data['start_time'], $data['end_time'], $data['duration']]);
        sendResponse('success', ['id' => $pdo->lastInsertId()]);
    } catch (Exception $e) { sendResponse('error', null, $e->getMessage()); }
}

elseif ($action == 'update_session') {
    $data = json_decode(file_get_contents("php://input"), true);
    try {
        $sql = "UPDATE sessions SET studio_id=?, customer_name=?, background=?, start_time=?, end_time=?, duration_minutes=? WHERE id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$data['studio_id'], $data['customer_name'], $data['background'], $data['start_time'], $data['end_time'], $data['duration'], $data['id']]);
        sendResponse('success');
    } catch (Exception $e) { sendResponse('error', null, $e->getMessage()); }
}

elseif ($action == 'delete_session') {
    $data = json_decode(file_get_contents("php://input"), true);
    try {
        $stmt = $pdo->prepare("DELETE FROM sessions WHERE id=?");
        $stmt->execute([$data['id']]);
        sendResponse('success');
    } catch (Exception $e) { sendResponse('error', null, $e->getMessage()); }
}

else { sendResponse('connected', null, 'API Ready'); }
?>
